
module ministate (reset,clock,ps1,ps2);
input reset,clock;
output ps1,ps2;
reg ps1,ps2;

parameter [1:0] /* synopsys enum foo */
	s0 = 2'b00, s1 = 2'b01, s2 = 2'b11, s3 = 2'b10;
reg [1:0] /* synopsys enum foo */ state, next_state;
/* synopsys state_vector state */

always @ (state or reset) begin

	case(state) // synopsys parallel_case full_case

	s0: begin
	    ps1 = 1'b0;
	    ps2 = 1'b0;
	    if(reset) 
		next_state = s0;
	    else
		next_state = s1;
	    end

	s1: begin
	    ps1 = 1'b1;
	    ps2 = 1'b0;
	    if(reset)
		next_state = s0;
	    else
		next_state = s2;
	    end

	s2: begin
	    ps1 = 1'b1;
	    ps2 = 1'b1;
	    if(reset)
		next_state = s0;
	    else
		next_state = s3;
	    end

	s3: begin
	    ps1 = 1'b0;
	    ps2 = 1'b1;
		next_state = s0;
	    end
	    endcase
	    end

	    always @ (posedge clock)

	    begin
	    state = next_state;
	    end
	    endmodule
